<?php
include "../controllers/floatings.php";
$floatings = new Floatings();
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $floatings = new Floatings();
  $floatings->setParams($_POST);
  $floatings->delete();
}
?>
<!-- Content Header (Page header) -->
<div class="container-fluid">

  <!-- Page Heading -->
  <div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">App Floating</h1>
    <ol class="breadcrumb float-sm-right">
      <li class="breadcrumb-item"><a href="index.php">Dashboard</a></li>
      <li class="breadcrumb-item active">Floating</li>
    </ol>
  </div>

  <div>
    <div class="card shadow mb-4">
      <!-- Card Header - Dropdown -->
      <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 font-weight-bold text-primary">List Floating</h6>

        <a href="?page=floating_add" class="btn btn-success btn-icon-split btn-sm">
          <span class="icon text-white-50">
            <i class="fas fa-plus"></i>
          </span>
          <span class="text">Add</span>
        </a>
      </div>
      <!-- Card Body -->
      <div class="card-body">
        <table id="example1" class="table table-bordered table-striped">
          <thead>
            <tr>
              <th>Icon</th>
              <th>Title</th>
              <th>Url</th>
              <th style="width: 150px;">Status</th>
              <th style="width: 210px;">Action</th>
            </tr>
          </thead>
          <tbody>
            <?php
            foreach ($floatings->getAll() as $f) {
            ?>
              <tr>
                <td><img src="../images/floating/<?= $f['icon'] ?>?<?= time() ?>" style="width:30px" class="img-thumbnail"></td>
                <td><?= $f['title'] ?></td>
                <td><a href="<?= $f['url'] ?>" target="_blank"><?= $f['url'] ?></a></td>
                <td>
                  <span class="badge <?= $f['status'] ? 'badge-success' : 'badge-secondary' ?>"><?= $f['status'] ? "Active" : "Inactive" ?></span>
                </td>
                <td>

                  <a href="?page=floating_edit&id=<?= $f['id'] ?>" class="btn btn-info btn-icon-split btn-sm">
                    <span class="icon text-white-50">
                      <i class="fas fa-pencil-alt"></i>
                    </span>
                    <span class="text">Edit</span>
                  </a>

                  <a href="#" data-toggle="modal" data-target="#responsive-modal<?= $f['id'] ?>" class="btn btn-danger btn-icon-split btn-sm">
                    <span class="icon text-white-50">
                      <i class="fas fa-trash"></i>
                    </span>
                    <span class="text">Delete</span>
                  </a>

                  <!-- /.modal -->
                  <div class="modal fade" id="responsive-modal<?= $f['id'] ?>">
                    <div class="modal-dialog">
                      <div class="modal-content">
                        <div class="modal-header">
                          <h4 class="modal-title">Delete</h4>
                          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                          </button>
                        </div>
                        <div class="modal-body">
                          <p>Are you sure you want to delete this floating <b><?= $f['title'] ?></b>
                            <img src="../images/floating/<?= $f['icon'] ?>?<?= time() ?>" style="width:30px" class="img-thumbnail"> ?</p>
                        </div>

                        <form id="form-responsive-modal<?= $f['id'] ?>" method="post">
                          <div class="modal-footer justify-content-between">
                            <input type="hidden" name="id" value="<?= $f['id'] ?>" />
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-danger waves-effect waves-light">Delete</button>
                        </form>
                      </div>
                    </div>
                    <!-- /.modal-content -->
                  </div>
                  <!-- /.modal-dialog -->
      </div>
      <!-- End Modal -->
      </td>


      </tr>

    <?php } ?>
    </tbody>
    <tfoot>
      <tr>
        <th>Icon</th>
        <th>Title</th>
        <th>Type</th>
        <th>Status</th>
        <th>Action</th>
      </tr>
    </tfoot>
    </table>
    </div>
  </div>
</div>
 